<?php

namespace Woovi\Pix\Observer;

class QuoteSubmitBefore implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * Convert woovi discount amount from quote to order
     *
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $quote = $observer->getEvent()->getQuote();
        $order = $observer->getEvent()->getOrder();

        $order->setData('woovi_discount', $quote->getData('woovi_discount'));
        $order->setData(
            'base_woovi_discount',
            $quote->getData('base_woovi_discount')
        );
    }
}
