<?php

namespace Woovi\Pix\Api;

interface WooviManagementInterface
{
    public const WOOVI_LOG_NAME = 'pix_collect';
    public const WOOVI_DISCOUNT_CODE = 'woovi_discount';
    public const WOOVI_CUSTOMER_BALANCE_SESSION = 'customer_woovi_data_session';

    public const GET_BALANCE_API = 'api/woovi/v1/giftback/balance';

    /**
     * Get balance of customer from Woovi API by customer Tax ID
     *
     * @param string $customerTaxId
     *
     * @return float
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getCustomerBalanceByTaxId($customerTaxId);

    /**
     * Calculate and convert the discount amount from customer balance and base grand total
     *
     * @param float $balance
     * @param \Magento\Quote\Model\Quote $quote
     * @param float $totalDiscountAmount
     *
     * @return float
     */
    public function calculateAndConvertBalance(
        $balance,
        $quote,
        $totalDiscountAmount
    );

    /**
     * Build getBalance API URL
     *
     * @param string $customerTaxId
     *
     * @return string
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getBalanceApiURL($customerTaxId);

    /**
     * Clear customer balance data in the session
     *
     * @return void
     */
    public function clearDataInCache();
}
