<?php

namespace Woovi\Pix\Model\Order\Creditmemo\Total;

class Discount extends \Magento\Sales\Model\Order\Creditmemo\Total\AbstractTotal
{
    /**
     * @param \Magento\Sales\Model\Order\Creditmemo $creditmemo
     *
     * @return $this
     */
    public function collect(\Magento\Sales\Model\Order\Creditmemo $creditmemo)
    {
        $creditmemo->setWooviDiscount(0);
        $creditmemo->setBaseWooviDiscount(0);

        $items = $creditmemo->getItems();
        if (!count($items)) {
            return $this;
        }

        $order = $creditmemo->getOrder();
        $totalWooviDiscount = $order->getWooviDiscount() ?? 0;
        $baseTotalWooviDiscount = $order->getBaseWooviDiscount() ?? 0;

        $creditmemo->setWooviDiscount(-$totalWooviDiscount);
        $creditmemo->setBaseWooviDiscount(-$baseTotalWooviDiscount);

        $creditmemo->setGrandTotal(
            $creditmemo->getGrandTotal() - $totalWooviDiscount
        );
        $creditmemo->setBaseGrandTotal(
            $creditmemo->getBaseGrandTotal() - $baseTotalWooviDiscount
        );
        return $this;
    }
}
