<?php

namespace Woovi\Pix\Model\Api;

use Magento\Framework\Module\ModuleListInterface;

class WooviApi
{
    const MODULE_NAME = 'Woovi_Pix';

    protected $_moduleList;

    /**
     * Woovi Helper
     *
     * @var Woovi\Pix\Helper\Data;
     */
    protected $_helperData;

    const LOG_NAME = 'pix_api';

    public function __construct(
        ModuleListInterface $moduleList,
        \Woovi\Pix\Helper\Data $helper
    ) {
        $this->_moduleList = $moduleList;
        $this->_helperData = $helper;
    }

    /**
     * {@inheritdoc}
     */
    public function getVersion()
    {
        $this->_helperData->log(
            'Woovi WebApi::GetVersion Start',
            self::LOG_NAME
        );

        $moduleVersion = $this->_moduleList->getOne(self::MODULE_NAME)[
            'setup_version'
        ];

        $this->_helperData->log(
            'Woovi WebApi::GetVersion $moduleVersion',
            self::LOG_NAME,
            $moduleVersion
        );

        return 'Woovi Pix Extension Version ' . $moduleVersion;
    }
}
