<?php

namespace Woovi\Pix\Model\Order\Invoice\Total;

class Discount extends \Magento\Sales\Model\Order\Invoice\Total\AbstractTotal
{
    /**
     * @param \Magento\Sales\Model\Order\Invoice $invoice
     * @return $this
     */
    public function collect(\Magento\Sales\Model\Order\Invoice $invoice)
    {
        $invoice->setWooviDiscount(0);
        $invoice->setBaseWooviDiscount(0);

        $items = $invoice->getItems();
        if (!count($items)) {
            return $this;
        }

        $order = $invoice->getOrder();
        $totalWooviDiscount = $order->getWooviDiscount() ?? 0;
        $baseTotalWooviDiscount = $order->getBaseWooviDiscount() ?? 0;

        $invoice->setWooviDiscount(-$totalWooviDiscount);
        $invoice->setBaseWooviDiscount(-$baseTotalWooviDiscount);

        $invoice->setGrandTotal(
            $invoice->getGrandTotal() - $totalWooviDiscount
        );
        $invoice->setBaseGrandTotal(
            $invoice->getBaseGrandTotal() - $baseTotalWooviDiscount
        );
        return $this;
    }
}
