<?php

namespace Woovi\Pix\Block\Sales\Order;

use Woovi\Pix\Api\WooviManagementInterface;

class Totals extends \Magento\Sales\Block\Adminhtml\Order\Totals
{
    /**
     * Get totals source object
     *
     * @return \Magento\Sales\Model\Order
     */
    public function getSource()
    {
        return $this->getParentBlock()->getSource();
    }

    /**
     * Create the weee ("FPT") totals summary
     *
     * @return $this
     */
    public function initTotals()
    {
        $wooviDiscount = abs($this->getSource()->getWooviDiscount());
        $baseWooviDiscount = abs($this->getSource()->getBaseWooviDiscount());
        if (empty($wooviDiscount)) {
            return $this;
        }

        $total = new \Magento\Framework\DataObject([
            'code' => WooviManagementInterface::WOOVI_DISCOUNT_CODE,
            'label' => __('Giftback Discount'),
            'value' => -$wooviDiscount,
            'base_value' => -$baseWooviDiscount,
        ]);

        $this->getParentBlock()->addTotalBefore($total, 'grand_total');

        return $this;
    }
}
