<?php

namespace Woovi\Pix\Block\Order\Payment;

class Info extends \Magento\Framework\View\Element\Template
{
    protected $_checkoutSession;
    protected $_orderFactory;

    /**
     * Woovi Helper
     *
     * @var Woovi\Pix\Helper\Data;
     */
    protected $_helperData;

    const LOG_NAME = 'pix_sales_order_block';

    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Sales\Model\Order $orderFactory,
        \Woovi\Pix\Helper\Data $helper,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->_checkoutSession = $checkoutSession;
        $this->_orderFactory = $orderFactory;
        $this->_helperData = $helper;
    }

    public function getPaymentMethod()
    {
        $order_id = $this->getRequest()->getParam('order_id');
        $order = $this->_orderFactory->load($order_id);
        $payment = $order->getPayment();

        $this->_helperData->log(
            'Pix::Block - Sales Order getPaymentMethod',
            self::LOG_NAME,
            $payment->getMethod()
        );
        return $payment->getMethod();
    }

    public function getPaymentInfo()
    {
        $order_id = $this->getRequest()->getParam('order_id');
        $order = $this->_orderFactory->load($order_id);

        return [
            'tipo' => 'Pix',
            'qrcodeimage' => $order->getWooviQrcodeimage(),
            'text' => 'Clique aqui para ver seu QRCode.',
            'brcode' => $order->getWooviBrcode(),
        ];
    }

    public function getAppID(): string
    {
        $appID = $this->_helperData->getAppID();

        if (isset($appID)) {
            return $appID;
        }

        return '';
    }

    public function getCorrelationID(): string
    {
        $order_id = $this->getRequest()->getParam('order_id');
        $order = $this->_orderFactory->load($order_id);
        $correlationID = $order->getWooviCorrelationid();

        if (isset($correlationID)) {
            return $correlationID;
        }

        return '';
    }

    public function getPluginSrc(): string
    {
        return $this->_helperData->getWooviPluginUrlScript();
    }
}
