<?php

class Woovi_Pix_Model_Observer
{
    use Woovi_Pix_Trait_ExceptionMessenger;
    use Woovi_Pix_Trait_LogMessenger;

    public function validateCustomer($customer)
    {
        $taxID = $customer["taxID"];

        $hasTaxID = isset($taxID);
        $isValidTaxIDLength = strlen($taxID) === 11;
        $isTaxIDValid = $hasTaxID && $isValidTaxIDLength;

        return $isTaxIDValid;
    }

    public function applyGiftback(Varien_Event_Observer $observer)
    {
    }

    protected function helper()
    {
        return Mage::helper("woovi_pix");
    }

    protected function orderHelper()
    {
        return Mage::helper("woovi_pix/order");
    }
}
