<?php

class Woovi_Pix_Block_Adminhtml_Config_OneclickButton extends Mage_Adminhtml_Block_System_Config_Form_Field
{
    protected function _construct()
    {
        parent::_construct();
        $this->setTemplate("woovi/config/oneclickButton.phtml");
    }

    /**
     * @return string
     */
    protected function _getElementHtml($element)
    {
        return $this->_toHtml();
    }

    /**
     * @return string
     */
    public function getAjaxPrepareOneclickUrl()
    {
        return Mage::getSingleton("adminhtml/url")->getUrl("woovi/adminhtml_ajax/prepareWooviOneclick");
    }

    /**
     * @return string
     */
    public function getButtonHtml()
    {
        $button = $this->getLayout()->createBlock("adminhtml/widget_button")
            ->setData([
                "id" => "woovi_pix_oneclick_button",
                "label" => $this->helper("adminhtml")->__("Connect the extension"),
                "onclick" => "wooviPrepareOneclick()",
              ]);
  
          return $button->toHtml();
    }
}